#include <bits/stdc++.h>
using namespace std;

long partition(long arr[], long start, long end) {
  long pivot = arr[start];
  long count = 0;
  for (long i = start + 1; i <= end; i++) {
    if (arr[i] <= pivot)
      count++;
  }
  long pivotIndex = start + count;
  swap(arr[pivotIndex], arr[start]);
  long i = start, j = end;
  while (i < pivotIndex && j > pivotIndex) {

    while (arr[i] <= pivot) {
      i++;
    }

    while (arr[j] > pivot) {
      j--;
    }

    if (i < pivotIndex && j > pivotIndex) {
      swap(arr[i++], arr[j--]);
    }
  }

  return pivotIndex;
}

void quickSort(long arr[], long start, long end) {
  if (start >= end)
    return;
  long p = partition(arr, start, end);
  quickSort(arr, start, p - 1);
  quickSort(arr, p + 1, end);
}

int main() {
  long N, M, K, L;
  cin >> N >> M >> K >> L;
  long *A = new long[N * M];
  for (long i = 0; i < N * M; i++) {
    cin >> A[i];
  };
  quickSort(A, 0, N * M - 1);
  long *P = new long[N * M];
  for (long i = 0; i < N; i++)
    for (long j = 0; j < M; j++)
      P[i * M + j] = min(min(i + 1, N - i), K) * min(min(j + 1, M - j), L);
  quickSort(P, 0, N * M - 1);
  long R = 0;
  for (long i = 0; i < N * M; i++)
    R += A[i] * P[i];
  delete[] A;
  delete[] P;
  cout << R << "\n";
}